DEFINE CLASS CursorBehavior as behaviorBase OF behaviorBase.prg
	
	*--- First Method
	*--- Places the pointer at the first record
	PROCEDURE First
		
		GO TOP 
		
	ENDPROC
	
	*--- Last method
	*--- Places the pointer at the bottom record
	PROCEDURE Last
		
		GO BOTTOM
		
	ENDPROC
	
	*--- Next Method
	*--- Moves the record pointer to the next record
	PROCEDURE Next
		
		IF NOT EOF()
			SKIP
			
			IF EOF()
				SKIP -1
			ENDIF
			
		ENDIF
		
	ENDPROC
	
	*--- Previous Method
	*--- Moves the record pointer to the previous record
	PROCEDURE Previous
		
		IF NOT BOF()
			SKIP -1
			
			IF BOF()
				SKIP
			ENDIF
			
		ENDIF
		
	ENDPROC
	
	*--- Requery Method
	*--- Requeries the Business Object View
	PROCEDURE Requery
		LPARAMETERS tcAlias, tnSession
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO tnSession
		
		*--- Call the native VFP Requery command
		REQUERY(tcAlias)
		
	ENDPROC
	
	*--- New Method
	*--- Uses VFP's Append Blank
	PROCEDURE New
		LPARAMETERS tcAlias, tnSession
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO tnSession
		
		*--- Call the native VFP Append command
		APPEND BLANK IN (tcAlias)
		
	ENDPROC
	
	*--- Delete Method
	*--- Deletes the current record
	PROCEDURE Delete
		LPARAMETERS tcAlias, tnSession
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO tnSession
		
		*--- Call the native VFP Delete command
		DELETE IN (tcAlias)
		
	ENDPROC
	
	*--- Save Method
	*--- Saves the current record
	PROCEDURE Save
		LPARAMETERS tcAlias, tnSession
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO tnSession
		
		*--- Call the native VFP TableUpdate command
		TABLEUPDATE(1, .F., tcAlias)
		
	ENDPROC
	
	*--- Cancel Method
	*--- Cancel the current record
	PROCEDURE Cancel
		LPARAMETERS tcAlias, tnSession
		
		*--- Set the appropriate Data Session
		SET DATASESSION TO tnSession
		
		*--- Call the native VFP TableRevert command
		TABLEREVERT(.T., tcAlias)
		
	ENDPROC
	
ENDDEFINE